export interface MarketPrice {
  id: string;
  product_id: string;
  market_id: string;
  price: number;
  unit: string;
  submitted_by: string;
  submitted_at: string;
  reliability_score?: number;
  image_url?: string;
}

export interface Market {
  id: string;
  name: string;
  location: string;
}

export interface SubmitMarketPriceRequest {
  product_id: string;
  market_id: string;
  price: number;
  unit: string;
}

export interface UpdatePricingAccessRequest {
  can_update_prices: boolean;
} 